 ; Ŀ
 ;   Sand - Text string and substring search and destroy                   
 ;   Copyright 1991, 1995, 1997 by Rocket Software                         
 ;                                                                         
 ; 

 ; Ŀ
 ;   Sand - kill text entities with a given substring.                     
 ;   Arguments: Loc, the substring to locate.                              
 ;              ss, a selection set of text to check.                      
 ;   Calls nothing, returns the number of text entities deleted.           
 ; 
 (DEFUN SAND (loc ss / rad ln loc numdel num so txt txa sta goon st pa)
 ; Ŀ
 ;   Size marker blips, get ss, make length counter half-string.           
 ; 
  (setq rad (/ (getvar "viewsize") 20))
 ; Ŀ
 ;   While there are text entities in the selection set.                   
 ; 
  (setq ln (strlen loc))
  (setq loc (strcase loc))
  (setq numdel 0)
  (setq num 0)
 ; Ŀ
 ;   While there are text entities in the selection set.                   
 ; 
  (while (setq so (ssname ss num))
         (setq num (1+ num))
 ; Ŀ
 ;   Check to make sure that (entget so) isn't nil, presumably because     
 ;   we entdeled it.  This shouldn't be a problem because num will have    
 ;   been incremented past it once it is deleted, but it seems to be.      
 ;   Hang on: we're using the ss repeatedly, without ssdel'ing erased      
 ;   entities - it's the one from the previous pass which causes trouble.  
 ; 
         (if (setq txa (entget so))
             (progn
                  (setq txt (strcase (cdr (assoc 1 txa))))
                  (setq sta 1)
                  (setq goon t)
                  (while (and goon
                              (= ln (strlen (setq st (substr txt sta ln)))))
                         (if (= st loc)
                             (progn
                                   (setq goon ())
                                   (setq pa (cdr (assoc 10 txa)))
                                   (grdraw (polar pa (/ pi 4) rad)
                                           (polar pa (* 1.25 pi) rad) 7)
                                   (grdraw (polar pa (* pi 0.75) rad)
                                           (polar pa (* pi 1.75) rad) 7)
                                   (setq numdel (1+ numdel))
                                   (entdel so))
                             (setq sta (1+ sta)))))))
 numdel)
 ; Ŀ
 ;   Sand end.                                                             
 ; 

 ; Ŀ
 ;   Sand.                                                                 
 ; 
 (DEFUN C:SAND (/ locls num txdel ss stra)
  (setq locls (list "PLOT DATE" "P:\\2000"))
  (setq num 0)
  (setq txdel 0)
  (if (setq ss (ssget "x" '((0 . "text"))))
      (while (setq stra (nth num locls))
             (setq num (1+ num))
             (setq txdel (+ txdel (sand stra ss)))))
  (prompt (strcat "\nText entities deleted: " (itoa txdel) "."))
 (princ))